/**
*@ author Sebastian Seyrich, Markus Mattes
*/

import java.rmi.Remote;
import java.rmi.RemoteException;

public interface RemoteClientControlInterface extends Remote{


	/**
	*Object will draw the grid again
	*/
	public void updateGrid(int x, int y, int os) throws RemoteException;

	/**
	*Activates and deactivates the calling object
	*Should activate and deactivate the input on the panel
	*/
	public void setActive(boolean b)  throws RemoteException;


	/**
	*Tells the player about the finished game because of 
	* - opponent has logged out				4
	* - opponent is the winner				1
	* - opponent has lost the game			2
	* - there is no winner					0
	*/
	public void endGame(int id) throws RemoteException;


}
