/**
*@ author Sebastian Seyrich, Markus Mattes
*/
import java.rmi.*;
import java.rmi.server.*;
import java.rmi.RemoteException;
import java.net.MalformedURLException;
import java.net.URL;

public class RemoteClientControl extends UnicastRemoteObject implements RemoteClientControlInterface{
    

    private ClientPanel playerPanel;
    

    public RemoteClientControl(ClientPanel _playerPanel) throws RemoteException{
	super();
	playerPanel=_playerPanel;
    }
    
    
    /**
     *Object will draw the grid again
     */
    public void updateGrid(int x,int y,int os) throws RemoteException{
	playerPanel.updateGrid(x,y,os);	
    }

    /**
     *Activates and deactivates the calling object
     *Should activate and deactivate the input on the panel
     */
    public void setActive(boolean b)  throws RemoteException{
	playerPanel.setActive(b);
    }
    
    
    /**
     *Tells the player about the finished game because of 
     * - opponent has logged out				4
     * - opponent is the winner				        2
     * - opponent has lost the game			        1
     * - there is no winner					0
     */
    public void endGame(int id) throws RemoteException{
	playerPanel.showInfo(id);
    }
    
    
}
