/**
*@ author Sebastian Seyrich, Markus Mattes
*/

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.net.URL;


/**
*Administrates a game, includes remotmethods for:
*	- throw a chip 
*	- log out 
*	- receive a message
*/
public interface GameInterface extends Remote{


	/**
	*registers a player on his RemoteClientControl-Object.
	*true yields succsesful
	*false not succsesful
	*/
	public boolean registerPlayer(RemoteClientControlInterface playerRCC) throws RemoteException;

	/**
	*Game will know about a new choice 
	*Sould check if the player is part of the game and if the choice was legal
	*Initiate the graphical update
	*/
	public void makeYourChoice(int x, int y) throws RemoteException;


	/**
	*You have logged out 
	*game will be deleted at the gameserver 		
	*/
	public void logout(RemoteClientControlInterface playerRCC) throws RemoteException;
		


}
