/**
*@ author Sebastian Seyrich, Markus Mattes
*/

import java.rmi.*;
import java.rmi.server.*;
import java.rmi.RemoteException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;
import java.awt.*;
/**
*Administrates a game, includes remotmethods for:
*	- throw a chip 
*	- log out 
*	- receive a message
*/
public class Game extends UnicastRemoteObject implements GameInterface{

    private Random random = new Random();
    private RemoteClientControlInterface playerRCC;
    private int[][] grid = new int[3][3];
    private Fieldsegment[][] fs = new Fieldsegment[3][3];
    private Label l = new Label("Bin eben initialisiert worden!",FlowLayout.CENTER); 

    public Game() throws RemoteException{
	super();
	Frame f = new BufferedFrameWithExit("Ich bin der Server - ich sehe ALLES");
	f.setLayout(new BorderLayout());
	f.setBackground(new Color(102,114,253));

	f.add("North",l);
	Panel p = new Panel(new GridLayout(3,3,2,2));
	for(int i=0;i<fs.length;i++)
	    for(int j=0;j<fs.length;j++){
		fs[i][j] = new Fieldsegment(i,j);
		p.add(fs[i][j]);
	    }
	Panel pd = new Panel(new FlowLayout(FlowLayout.CENTER));
	pd.add(p);
	f.add("Center",pd);
	f.setSize(220,220);
	f.show();
    }
    /**
     *registers a player on his RemoteClientControl-Object.
     *true yields succsesful
     *false not succsesful
     */
    public boolean registerPlayer(RemoteClientControlInterface playerRCC) throws RemoteException{ 
	if(this.playerRCC==null){
	    grid = new int[3][3];
	    for(int i=0;i<fs.length;i++)
		for(int j=0;j<fs.length;j++)
		    fs[i][j].reset();
	
	    System.out.println("Game: habe einen Partner frs Leben!!");
	    this.playerRCC = playerRCC;
	    int whoshallbeactive = random.nextInt()%2;
	    if(whoshallbeactive==1){
		this.playerRCC.setActive(true);
	    }
	    else{
		this.playerRCC.setActive(false);
		computerChoice();
	    }
	    return true;
	}
	else{
	    System.out.println("Game: habe schon einen Partner - muss erst sterben, bevor ich einen neuen haben darf!");
	    return false;
	}
    }
    
    /**
     *Game will know about a new choice 
     *Sould check if the player is part of the game and if the choice was legal
     *Initiate the graphical update
     */
    public void makeYourChoice(int x, int y) throws RemoteException{
	if(grid[x][y]==0){
	    playerRCC.updateGrid(x, y, Fieldsegment.PLAYERA); System.out.println( x+"/"+y);
	    grid[x][y]= Fieldsegment.PLAYERA; 
	    fs[x][y].setOwnerStatus(Fieldsegment.PLAYERA);
	    l.setText("Computer Ddel computetZug");
	    playerRCC.setActive(false);
	    int testresult = 0;
	    if((testresult=test(x,y,Fieldsegment.PLAYERA))!=-1){
		playerRCC.endGame(testresult);
		showInfo(testresult);
		return;
	    }
	    computerChoice();
	}
	else
	    playerRCC.setActive(true);	
    }
    private int test(int x,int y,int player ){
	if(grid[0][0]==player&&grid[0][1]==player&&grid[0][2]==player)
	    return player;
	if(grid[1][0]==player&&grid[1][1]==player&&grid[1][2]==player)
	    return player;
	if(grid[2][0]==player&&grid[2][1]==player&&grid[2][2]==player)
	    return player;
	if(grid[0][0]==player&&grid[1][0]==player&&grid[2][0]==player)
	    return player;
	if(grid[0][1]==player&&grid[1][1]==player&&grid[2][1]==player)
	    return player;
	if(grid[0][2]==player&&grid[1][2]==player&&grid[2][2]==player)
	    return player;
	if(grid[0][0]==player&&grid[1][1]==player&&grid[2][2]==player)
	    return player;
	if(grid[0][2]==player&&grid[1][1]==player&&grid[2][0]==player)
	    return player;
	if(grid[0][0]!=0&&grid[0][1]!=0&&grid[0][2]!=0&&grid[1][0]!=0&&grid[1][1]!=0&&grid[1][2]!=0&&grid[2][0]!=0&&grid[2][1]!=0&&grid[2][2]!=0)
	   return 0;
	return -1;
	    
    }
    private void computerChoice()throws RemoteException{
	int x = 1;
	int y = 1;
	while(grid[x][y]!=0){
	    x = Math.abs(random.nextInt()%3);
	    y =  Math.abs(random.nextInt()%3);
	}
	grid[x][y]=Fieldsegment.PLAYERB;
	fs[x][y].setOwnerStatus(Fieldsegment.PLAYERB);
	l.setText("Foo Bar ist am Zug");
	int testresult = 0;
	if((testresult=test(x,y,Fieldsegment.PLAYERB))!=-1){
	    playerRCC.endGame(testresult);
	    showInfo(testresult);
	    playerRCC.updateGrid(x, y, Fieldsegment.PLAYERB);
	    return;
	}
	playerRCC.updateGrid(x, y, Fieldsegment.PLAYERB);
	playerRCC.setActive(true);
    }
    
    /**
     *You have logged out 
     *game will be deleted at the gameserver 		
     */
    public void logout(RemoteClientControlInterface playerRCC) throws RemoteException{
	System.out.println("\nDer Mitspieler hat sich verabschiedet,\nnun bin ich wieder zu haben\n\n");
	this.playerRCC=null;
	grid = new int[3][3];
	for(int i=0;i<fs.length;i++)
	    for(int j=0;j<fs.length;j++)
		fs[i][j].reset();
	l.setText("Ich fhle mich so allein, allein...");
    }
 protected void showInfo(int id){
	if(id==3){
	    l.setText("Ein schnes Spiel, oder?");
	}
	if(id==2){
	   
	    l.setText("Sie haben verloren");
	}
	if(id==1){
	   
	    l.setText("Sie haben gewonnen");
	}
	if(id==0){
	   
	    l.setText("Unentschieden, wie einfallslos!");
	}
	if(id==4){
	   
	    l.setText("Sie sind allein, neues Spiel starten?");
	}
	
    }
    public static void main (String args[]){
	try{
	    
	    if(System.getSecurityManager()==null)
		System.setSecurityManager(new RMISecurityManager());
	    System.out.println("Game: SecurityManager intalliert");
	    Game game = new Game();
	    System.out.println("Game: Game initialisiert");
	    Naming.rebind("Game",game);
	    System.out.println("Game: erfolgreich bei Naming angemeldet");

	}
	catch (Exception e){
	    System.out.print(e.toString());
	}

    }
    
}
