import java.awt.*;
import java.awt.event.*;

public class Fieldsegment extends Panel implements  MouseListener{
    
    public final static int PLAYERA=1;
    public final static int PLAYERB=2;
    public final static int  EMPTY=0;
    private int ownerStatus;
    private Dimension dim;
    private ClientPanel cp;
    private boolean active = false;
    private int x,y;
    private boolean entered = false;
    private final static Color backColorA = new Color(13,126,3);
    private final static Color backColorN = new Color(200,16,16);
    private final static Color playerAColorA = new Color(0,3,200);
    private final static Color playerAColorN = new Color(100,178,200);
    private final static Color playerBColorA = new Color(200,129,37);
    private final static Color playerBColorN = new Color(200,174,118);

    public Fieldsegment(int x,int y){
	super();
	ownerStatus = EMPTY;
	this.addMouseListener(this);
	dim = new Dimension(50,50);
	this.x = x;
	this.y = y;
    }
   
    public  Fieldsegment(int x, int y,ClientPanel cp){
	this(x,y);
	this.cp = cp;
    }
 
    public void setActive(boolean b){
	active = b;
	if(!b){
	    entered = false;
	    repaint();
	}
    }

    public void reset(){
	ownerStatus = EMPTY;
	repaint();
    }

    public void setOwnerStatus(int os){
	//	System.out.println(os+" x/y: "+x+"/"+y );
	ownerStatus = os; 
	repaint();
    }

    public void paint(Graphics g){

	int oval = (int)((1.0/6.0)*dim.height);	
	int ovalW = dim.height-2*oval;
	if(entered){
	    g.setColor(backColorA);
	    g.drawRect(0,0,dim.height-1,dim.width-1);
	    g.setColor(backColorA.brighter());
	    g.fillRect(2,2,dim.height-4,dim.width-4);
	    if(ownerStatus==PLAYERA)
	       g.setColor(playerAColorA);
	    else if(ownerStatus==PLAYERB)
		g.setColor(playerBColorA);
	    if(ownerStatus!=EMPTY)
		g.fillOval(oval,oval,ovalW,ovalW);
		
	    
	}
	else{
	    g.setColor(backColorN);
	    g.drawRect(0,0,dim.height-1,dim.width-1);
	    g.setColor(backColorN.brighter());
	    g.fillRect(2,2,dim.height-4,dim.width-4);
	    if(ownerStatus==PLAYERA)
		g.setColor(playerAColorN);
	    else if(ownerStatus==PLAYERB)
		g.setColor(playerBColorN);
	   if(ownerStatus!=EMPTY) 
	       g.fillOval(oval,oval,ovalW,ovalW);	
	    //System.out.println(" x/y: "+x+"/"+y +"(paint)"); 
	}

    }

    /**
     *layoutmanager should not shrink the surounding container
     *to size 0x0
     */
    public Dimension getMaximumSize(){
	return dim;
    }
    public Dimension getMinimumSize(){
	return dim;
    } 
    public Dimension getPreferredSize(){
	return dim;
    } 
    public synchronized void mouseClicked(MouseEvent e) {
	if((cp!=null)&&active){
	    cp.setActive(false);
	    //ownerStatus = PLAYERA;
	    cp.makeYourChoice(x,y);
	}
    }
    
    public void mouseEntered(MouseEvent e) {
	if((cp!=null)&&active){
	    entered = true;
	    repaint();
	}
    }


    
    public void mouseExited(MouseEvent e) {
	if((cp!=null)&&active){
	    entered = false;
	    repaint();
	}
    }
    
    public void mousePressed(MouseEvent e) {}
    
    public void mouseReleased(MouseEvent e) {}
     
}
