/**
 *@ author Sebastian Seyrich, Markus Mattes
 */

import java.applet.*;
import java.rmi.*;
import java.rmi.server.*;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.awt.*;
import java.awt.event.*;

public class ClientPanel extends Panel{
    
    private GameInterface game;
    private RemoteClientControlInterface rcc;
    private String name; 
    private String url;
    
    private Panel infoAboutThat;
    private Panel infoAndChoice;
    private Label gameStatus = new Label("bitte Spiel ordern",Label.CENTER);
    private TextField nameInput;
    private Panel col;
      
    //    private boolean active;
    private int sizeFactor = 60;
    private Dimension dim = new Dimension(60*7*2,60*7*3);    
    private Fieldsegment [][] fieldSegment;
    private Panel field = new Panel (new GridLayout(3,3,2,2));
    private Label l00;
 
    
    public ClientPanel(String _url){
	url = _url;
	fieldSegment=new Fieldsegment[3][3];
	nameInput = new TextField(15);
	nameInput.addActionListener(
				    new ActionListener(){
					    public void actionPerformed(ActionEvent e){
						name = nameInput.getText();
						l00.setText("Liebes Wesen, genannt "+name+", sei");
						init();
					    }
					}
				    );
	nameInput.setForeground(Color.white);
	nameInput.setBackground(new Color(1,11,129));
	infoAboutThat = new Panel(new GridLayout(6,1));
	l00 = new Label("Liebes Wesen, genannt "+name+" ,sei");
	l00.setBackground(new Color(102,114,253));
	l00.setForeground(Color.black);
	Label l0 = new Label("willkommen bei einer Onlinefassung von",Label.CENTER);
	l0.setBackground(new Color(102,114,253));
	l0.setForeground(Color.black);
	l0.setFont(new Font("Helvetica",Font.PLAIN,12));
	Label l1 = new Label("TicTacToe",Label.CENTER);
	l1.setBackground(new Color(102,114,253));
	l1.setForeground(Color.black);
	l1.setFont(new Font("Helvetica",Font.BOLD,12));
	Label l2 = new Label("Ziel ist es, drei der eigenen Spielsteine in ",Label.LEFT);
	l2.setBackground(new Color(102,114,253));
	l2.setForeground(Color.black);
	l2.setFont(new Font("Helvetica",Font.PLAIN,12));
	Label l3 = new Label("horizontaler, vertikaler oder diagonaler ",Label.LEFT);
	l3.setBackground(new Color(102,114,253));
	l3.setForeground(Color.black);
	l3.setFont(new Font("Helvetica",Font.PLAIN,12));
	Label l4 = new Label("Reihe anzuordnen.",Label.LEFT);
	l4.setBackground(new Color(102,114,253));
	l4.setForeground(Color.black);
	l4.setFont(new Font("Helvetica",Font.PLAIN,12));
	infoAboutThat.add(l00);
	infoAboutThat.add(l0);
	infoAboutThat.add(l1);
	infoAboutThat.add(l2);
	infoAboutThat.add(l3);
	infoAboutThat.add(l4);
	infoAndChoice = new Panel(new BorderLayout(5,5));
	infoAndChoice.setBackground(new Color(102,114,253));
	infoAndChoice.add("North",infoAboutThat);
	Panel choicePanel = new Panel(new FlowLayout(FlowLayout.CENTER));
	Button newGameButton = new Button(" Neues Spiel ");
	newGameButton.addActionListener(
					new ActionListener(){
						public void actionPerformed(ActionEvent e){
						    if(game!=null){
							try{game.logout(rcc);}
							catch(RemoteException ee){System.out.println("ClientPanel RemoteException ist aufgetreten:\n"+ee.toString());}
						    }
						    for (int i=0; i<fieldSegment.length; i++)
							for (int j=0; j<fieldSegment.length; j++){
							    fieldSegment[i][j].reset();
							    
							}

						   
						  
						    if(!initNewGame()){
							removeAll();
							Label l = new Label("Schutzverletzung im Modul connect",Label.CENTER);
							l.setForeground(Color.white);
							setBackground(Color.blue);
							l.setFont(new Font("Helvetica",Font.PLAIN,16));
							add(l);
							validate();
						    }
						}
					    }
					);
	Button exitButton = new Button(" Spiel beenden ");
	exitButton.addActionListener(
				     new ActionListener(){
					     public void actionPerformed(ActionEvent e){
						 if(game!=null){
						     try{game.logout(rcc);}
						     catch(RemoteException ee){System.out.println("ClientPanel RemoteException ist aufgetreten:\n"+ee.toString());}
						 }
						 System.exit(0);
					     }
					 }
				     );
	exitButton.setForeground(Color.black);
	newGameButton.setForeground(Color.black);
	exitButton.setBackground(new Color(102,114,253));
	newGameButton.setBackground(new Color(102,114,253));
	choicePanel.setBackground(new Color(102,114,253));
	choicePanel.add(newGameButton);
	choicePanel.add(exitButton);
	infoAndChoice.add("Center",choicePanel); 
	infoAndChoice.add("South",gameStatus); 
	infoAndChoice.add("North",infoAboutThat);
	setLayout(new BorderLayout(20,20));
	Panel nameInputPanel = new Panel(new GridLayout(2,1));
	Panel nameInputInnerPanel = new Panel(new FlowLayout(FlowLayout.CENTER));
	nameInputInnerPanel.add(nameInput);
	nameInputPanel.add(new Label("Seien Sie doch bitte so nett, einen netten Namen einzugeben, Schanke Dn! ",Label.CENTER));
	nameInputPanel.add(nameInputInnerPanel);setSize(dim);
	nameInputPanel.setBackground(new Color(1,11,129));
	setBackground(new Color(1,11,129));
	nameInputInnerPanel.setBackground(new Color(1,11,129));
	setForeground(Color.white);
	add("Center",nameInputPanel);
    }
    
    private void init(){
	removeAll();
	setBackground(new Color(1,11,129));
	for (int i=0; i<fieldSegment.length; i++)
	    for (int j=0; j<fieldSegment.length; j++){
		fieldSegment[i][j] = new Fieldsegment (i,j,this);
		field.add(fieldSegment[i][j]);

	    }
	col = new Panel(new FlowLayout(FlowLayout.LEFT,30,30));
	col.add(field);
	col.setBackground(new Color(181,197,253));
	col.add(infoAndChoice);
	add("Center",col);
	
	showInfo(3);
	setSize(dim);
	validate();
    }
    
    protected void showInfo(int id){
	if(id==3){
	    gameStatus.setText("Ein schnes Spiel, oder?");
	}
	if(id==2){
	    setActive(false);
	    gameStatus.setText(name+", Sie haben verloren");
	}
	if(id==1){
	    setActive(false);
	    gameStatus.setText(name+", Sie haben gewonnen");
	}
	if(id==0){
	    setActive(false);
	    gameStatus.setText("Unentschieden, wie einfallslos "+name+"!");
	}
	if(id==4){
	    setActive(false);
	    game=null;
	    gameStatus.setText("Sie sind allein, neues Spiel starten?");
	}
	
    }
    
    /**
     *Initializes a new game.
     * - Tries to get a new game from gameserver (break after 4 useless tries)
     * - responible for the update of the graphics
     */
    public boolean initNewGame(){

	boolean failed=true;
	int attemptNo=0;
	do{
	    try{
		attemptNo++;
		gameStatus.setText("Verbindung aufbauen, bitte warten");
		System.out.println("\n\n\t*******************************************************************\n\n\t\t\tT H E  T E S T C L I E N T P A N E L\n\n\t********************************************************************\n\n\n");
		if(System.getSecurityManager()==null)
		    System.setSecurityManager(new RMISecurityManager());
		System.out.println("ClientPanel SecurityManager installiert");
		game = (GameInterface) Naming.lookup("//"+url+"/Game");
		System.out.println("ClientPanel Game erhalten");
		System.out.print("\nVersuche RemoteClientControl zu bauen...");
		rcc = new RemoteClientControl(this);
		System.out.print("gelungen\nVersuche RemoteClientControl an Game zu registireren...");
		if(game.registerPlayer(rcc)){
		    System.out.print("gelungen\n\n");
		    failed=false;
		}
		else{
		    System.out.print("versagt\n\n");
		    failed = true;
		    attemptNo++;
		}
	
	    }
	    catch(NotBoundException e){System.out.println("ClientPanel NotBoundException ist aufgetreten:\n"+e.toString());}
	    catch(RemoteException e){System.out.println("ClientPanel RemoteException ist aufgetreten:\n"+e.toString());}
	    catch(MalformedURLException e){System.out.println("ClientPanel RemoteException ist aufgetreten:\n"+e.toString());}
	    catch(Exception e){System.out.println("ClientPanel Any exeption occured: \n"+e);}  
	}while(failed&&attemptNo<4);
	if(failed){
	    return false;
	}
	
	return true;
    }
    
    /**
     *Called from RRC, passed to the fitting column-component to refresh it
     */
    public void  updateGrid(int x,int y,int os){
	//	System.out.println( x+"/"+y);
	fieldSegment[x][y].setOwnerStatus(os);
	//	System.out.println("CP:"+ os);
	repaint();
   }
    
    /**
     *@ return the player's name
     */
    public String getName(){
	return name;
    }
    
        
    /**
     *Activates and deactvates the rows of the panels
     */
    public void setActive(boolean b){
	//active = b;
	//	System.out.println("ClientControl: active("+b+")");
	for (int i=0; i<fieldSegment.length; i++)
	    for (int j=0; j<fieldSegment.length; j++)
		fieldSegment[i][j].setActive(b);
	if(b)
	    gameStatus.setText("Sie sind am Zug");
	else
	    gameStatus.setText("Sie sind nicht am Zug");
    }
    
    
    /**
     *layoutmanager should not shrink the surounding container
     *to size 0x0
     */
    public Dimension getMaximumSize(){
	return dim;
    }
    public Dimension getMinimumSize(){
	return dim;
    } 
    public Dimension getPreferredSizeSize(){
	return dim;
    } 
    
    /**
     *Can be called from a FourWinsApplet's stop() method
     *it will stop the running game (if exists) like the "Spiel Beenden" Button
     *and clears all columns, so that if the applet is started again
     *a new game is possible
     */
    public void stop(Applet a){
	if(game!=null){
	    try{game.logout(rcc);}
	    catch(RemoteException ee){System.out.println("ClientPanel RemoteException ist aufgetreten:\n"+ee.toString());}
	    for (int i=0; i<fieldSegment.length; i++)
		for (int j=0; j<fieldSegment.length; j++){
		    fieldSegment[i][j] = new Fieldsegment (i,j,this);
		    field.add(fieldSegment[i][j]);
		}
	}
    }
    
    public void start(Applet a){
	init();
    }    
    


    /**
     *Called from columncomponent, call will be passed to game
     */
    public void makeYourChoice(int x,int y){
	try{
	    gameStatus.setText("Sie sind nicht am Zug");
	    game.makeYourChoice(x,y);
	}
	catch(RemoteException e){
	    gameStatus.setText("Sie sind am Zug");
	    System.out.println("ClientPanel RemoteException ist aufgetreten:\n"+e.toString());
	}
	
    }
    
    public static void main(String args[]){

	Frame f = new BufferedFrameWithExit("TicTacToe oder so");
	f.add(new ClientPanel("127.0.0.1"));
	//	f.pack();
	f.setSize(600,480);
	f.show();

    }
}
