/**
*@ author Sebastian Seyrich, Markus Mattes
*/

import java.awt.*;
import java.awt.event.*;


public class BufferedFrameWithExit extends Frame  implements WindowListener{
	private Image dbImage;
	private Graphics dbGraphics;

	public BufferedFrameWithExit(){
		super();
		addWindowListener(this);

	}
	
	public BufferedFrameWithExit(String s){
		super(s);
		addWindowListener(this);
	}

	public void update(Graphics g){
		//initialize double-buffer
		if(dbImage == null||this.getSize().height!=dbImage.getHeight(this)||this.getSize().width!=dbImage.getWidth(this)){
			dbImage = createImage(this.getSize().width, this.getSize().height);
			dbGraphics = dbImage.getGraphics();
		}
		//delete background
		dbGraphics.setColor(getBackground());
		dbGraphics.fillRect(0,0,this.getSize().width, this.getSize().height);
		//draw foreground
		dbGraphics.setColor(getForeground());
		paint(dbGraphics);
		//show offscreen
		g.drawImage(dbImage,0,0,this);
	}

	


    public void windowClosing(WindowEvent e) {
	   	dispose();        
	   	System.exit(0);  
    }
    
    public void windowClosed(WindowEvent e) {}
    public void windowActivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}
    public void windowDeactivated(WindowEvent e) {}
   
    
    


}