// Dieses Programm an sich 
// sowie die Zusammenstellung dieser Programme und Dokumentationen 
// sind urheberrechtlich geschuetzt.
// (c) 1999 Michael Dom und Wolfgang Westje
// Alle Rechte vorbehalten.

package ServerAufg1;

import java.util.*;
import VierGewinnt.*;

/**
 * Der PartieManager.<br>
 * Verwaltet offene (d.h. auf einen Gegner wartende) Partien.
 * @author Michael Dom, Wolfgang Westje
 */
public class PartieManagerImpl extends _PartieManagerImplBase {

/**
 * Konstruiert ein persistentes PartieManager-Objekt.
 * @param name Name der Instanz.
 */
    public PartieManagerImpl(String name) {
	super(name);
    }

/**
 * Konstruiert ein transientes PartieManager-Objekt.
 */
    public PartieManagerImpl() {
	super();
    }

/**
 * Er&ouml;ffnet eine neue Partie oder l&auml;&szlig;t an bestehender Partie
 * teilnehmen.
 * @param name Name der Partie.
 * @return Das Partie-Objekt.
 */
    public Partie4gewinnt spielen(String name) {
	Partie4gewinnt partie = (Partie4gewinnt) partieliste.get(name);
	if (partie==null) {
	    partie = new Partie4gewinntImpl(); 
	    try {
		partieliste.put(name,partie);
	    } catch (NullPointerException e) {}
	} else {  
	    partieliste.remove(name); 
	}
	return partie;
    }

/**
 * Listet offene Partien auf.
 * @return Liste der Partien, getrennt durch Zeilenumbr&uuml;che.
 */
    public String auflisten() {
	StringBuffer buffer = new StringBuffer();
	String newline = System.getProperty("line.separator");
	for (Enumeration e = partieliste.keys() ; e.hasMoreElements() ;) {
	    buffer.append((String) (e.nextElement())).append(newline);
	}	
	return buffer.toString();
    }
 
    private Hashtable partieliste = new Hashtable();
}
