// Dieses Programm an sich 
// sowie die Zusammenstellung dieser Programme und Dokumentationen 
// sind urheberrechtlich geschuetzt.
// (c) 1999 Michael Dom und Wolfgang Westje
// Alle Rechte vorbehalten.

package ServerAufg1;

/**
 * Das Spielfeld mit der Zuglogik.
 * @author Michael Dom, Wolfgang Westje
 */
public class Partie4gewinntImpl extends VierGewinnt._Partie4gewinntImplBase {

    private short hoehe = VierGewinnt.hoehe.value;
    private short breite = VierGewinnt.breite.value;
    private short[][] feld = new short[breite][hoehe+1];

    private int[] ticket = { 0, 0 };
    private short amZug = 1;
    private boolean partieLaeuft = false;

/**
 * Meldet den Aufrufenden bei der Partie an.
 * @param clientTicket liefert einen Identifikator zur k&uuml;nftigen 
 * Authentifikation zur&uuml;ck.
 * @return Spielernummer (1 oder 2).
 */
    public short init(org.omg.CORBA.IntHolder clientTicket) {

	java.util.Random random = new java.util.Random();

	if (ticket[0]==0) {
	    do { 
		ticket[0] = random.nextInt(); 
	    } while (ticket[0]==0);
	    clientTicket.value=ticket[0];
	    return 1; // Spieler 1 bekommt Ticket
	}
	
	do { 
	    ticket[1] = random.nextInt(); 
	} while (ticket[1]==0);
	partieLaeuft = true;
	clientTicket.value=ticket[1];
	return 2;  // Spieler 2 bekommt Ticket

    }

/**
 * Liefert den Spielstatus zur&uuml;ck.
 * @param clientTicket Zahl zur Identifikation des Anfragenden.
 * @return <table border=1>
 * <tr><th>Statuswert</th><th>Bedeutung</th></tr>
 * <tr><td>-1</td><td>ung&uuml;ltiges Ticket</td></tr>
 * <tr><td>1</td><td>Anfrager ist am Zug</td></tr>
 * <tr><td>2</td>
 *     <td>Anfrager ist nicht am Zug bzw. hat noch keinen Gegner</td></tr>
 * <tr><td>3</td><td>Anfrager hat gewonnen</td></tr>
 * <tr><td>4</td><td>Anfrager hat verloren</td></tr>
 * <tr><td>5</td><td>Unentschieden</td></tr>
 * </table>
 */
    public short status(int clientTicket) {

	if (((clientTicket!=ticket[0]) && (clientTicket != ticket[1])) 
	    || (clientTicket==0)) return -1;
	// falsches Ticket (kommt nicht vor) 
	// oder keiner hat bisher init() aufgerufen
	
	if (gewonnen((short)((clientTicket==ticket[0])? 1:2))) return 3;
	// Anfrager hat gewonnen

	if (gewonnen((short)((clientTicket==ticket[0])? 2:1))) return 4;
	// Anfrager hat verloren

	// Unentschieden:
	int summe = feld[0][0];
	for (int i=1; i<breite; summe+=feld[i++][0]);
	if (summe==breite*hoehe) {
	    partieLaeuft=false;
	    return 5;
	}

	if (!partieLaeuft) return 2; //Noch kein Gegenspieler

	return (clientTicket==ticket[amZug-1]) ? (short)(1) : (short)(2);
    }


/**
 * Wirft einen Stein in die &uuml;bergebene Spalte.
 * @param clientTicket Zahl zur Identifikation des Anfragenden.
 * @param spalte Zielspalte.
 * @return <table border=1>
 * <tr><th>Statuswert</th><th>Bedeutung</th></tr>
 * <tr><td>-1</td><td>ung&uuml;ltiges Ticket oder Gegner ist am Zug</td></tr>
 * <tr><td>1</td><td>ung&uuml;ltiger Zug; Spieler ist weiterhin an der Reihe</td></tr>
 * <tr><td>2</td>
 *     <td>G&uuml;ltiger Zug; der Gegner ist jetzt an der Reihe</td></tr>
 * <tr><td>3</td><td>Spieler hat gewonnen</td></tr>
 * <tr><td>4</td><td>Zug nicht ausgef&uuml;hrt, Gegner hatte schon gewonnen</td></tr>
 * <tr><td>5</td><td>Unentschieden</td></tr>
 * </table>
 */

    public short ziehen(int clientTicket, short spalte) {
	if (clientTicket==0) return -1;
	if (clientTicket!=ticket[amZug-1]) return -1; // falsches Ticket oder der Gegner ist dran
	if (partieLaeuft) {
	    if ((spalte>breite) || (spalte<=0) || 
		(feld[spalte-1][0]>=hoehe)) return 1;  // ungueltiger Zug?
	    feld[spalte-1][0]++;
	    feld[spalte-1][feld[spalte-1][0]] = amZug;  // zieh!
	    amZug = (short) (amZug % 2 + 1);
	    if (spalteGewonnen((short)(amZug % 2 +1), spalte)) {   // Gewonnen?
		partieLaeuft = false;
		return 3;
	    }
	}
	// Unentschieden?
	int summe = feld[0][0];
	for (int i=1; i<breite; summe += feld[i++][0]);
	if (summe==breite*hoehe) {
	    partieLaeuft = false;
	    return 5;
	}    
	// jetzt ist der Gegner dran oder Partie war schon verloren! 
	return (partieLaeuft) ? (short) 2 : (short) 4;
    }
    
/**
 * Gibt das Spielfeld zur&uuml;ck.
 * @return Das aktuelle Spielfeld.
 */
    public short[][] holeSpielfeld() {
	return feld;
    }

    private boolean spalteGewonnen(short spieler, short spalte) {
	spalte--; // Anpassung, da 0-basiertes Spielfeld
	
	short zaehler = 0;

	// links
	short x = spalte;
	short y = feld[spalte][0];

	if (y==0) return false; // kein Stein in Spalte
	
	while ((x>=0) && (zaehler<4) && (feld[x][y]==spieler)) {
	    zaehler++;
	    x--;
	}
	if (zaehler==4) return true;
	
	// rechts
	x = (short) (spalte + 1);
	while ((x<breite) && (zaehler<4) && (feld[x][y]==spieler)) {
	    zaehler++;
	    x++;
	}
	if (zaehler==4) return true;
	
	// links unten
	zaehler = 0;
	x = spalte;
	while ((x>=0) && (y>=1) && (zaehler<4) && (feld[x][y]==spieler)) {
	    zaehler++;
	    x--;
	    y--;
	}
	if (zaehler==4) return true;
	
	// rechts oben
	x = (short)(spalte+1);
	y = (short)(feld[spalte][0]+1);
	while ((x<breite) && (y<=hoehe) && (zaehler<4) && (feld[x][y]==spieler)) {
	    zaehler++;
	    x++;
	    y++;
	}
	if (zaehler==4) return true;
	
	// links oben
	zaehler = 0;
	x = spalte;
	y = feld[spalte][0];
	while ((x>=0) && (y<=hoehe) && (zaehler<4) && (feld[x][y]==spieler)) {
	    zaehler++;
	    x--;
	    y++;
	}
	if (zaehler==4) return true;
	
	// rechts unten
	x = (short)(spalte+1);
	y = (short)(feld[spalte][0]-1);
	while ((x<breite) && (y>=1) && (zaehler<4) && (feld[x][y]==spieler)) {
	    zaehler++;
	    x++;
	    y--;
	}
	if (zaehler==4) return true;
	
	// unten
	zaehler = 0;
	y = feld[spalte][0];
	while ((y>=1) && (zaehler<4) && (feld[spalte][y]==spieler)) {
	    zaehler++;
	    y--;
	}
	if (zaehler==4) return true;

	return false;
    }

    private boolean gewonnen(short spieler) {
	for (short i=1; i<=breite; i++) 
	    if (spalteGewonnen(spieler, i)) return true;
	return false;
    }
    
}
