// Dieses Programm an sich 
// sowie die Zusammenstellung dieser Programme und Dokumentationen 
// sind urheberrechtlich geschuetzt.
// (c) 1999 Michael Dom und Wolfgang Westje
// Alle Rechte vorbehalten.

// setenv THREADS_FLAG native

package ServerAufg1;

/**
 * Der JAVA Computergegner.
 * @author Michael Dom, Wolfgang Westje
 */
public class MeisterImpl extends VierGewinnt._MeisterImplBase {
    private static final short GEGNERVORAUSSCHAU=0;
    private static final short MINDESTSICHERHEIT=0;
    private static final short SICHERHEITSBONUS=1;
    private static int MAXZEIT = 3000;//Gesamtzeit = 2 1/3 * MAXZEIT (in msec)

    private static short hoehe = VierGewinnt.hoehe.value;
    private static short breite = VierGewinnt.breite.value;

    private static boolean berechnungsStop = false;

    private static short[][] feld;
    
/**
 * Konstruiert ein persistentes JAVAMeister-Objekt.
 * @param name Name der Instanz.
 */
    public MeisterImpl(String name) {
	super(name);
    }
/**
 * Konstruiert ein transientes JAVAMeister-Objekt.
 */
    public MeisterImpl() {
	super();
    }


    private static boolean spalteGewinnt(short spalte, short spieler) {
	spalte--; // Anpassung, da 0-basiertes Spielfeld
	
	short zaehler = 1;
	    
	if (feld[spalte][0]==hoehe) return false;
		
	// links
	short x = (short)(spalte-1);
	short y = (short)(feld[spalte][0]+1);
	while ((x>=0) && (zaehler<4) && (feld[x][y]==spieler)) {
	    zaehler++;
	    x--;
	}
	if (zaehler==4) return true;
	
	// rechts
	x = (short) (spalte + 1);
	while ((x<breite) && (zaehler<4) && (feld[x][y]==spieler)) {
	    zaehler++;
	    x++;
	}
	if (zaehler==4) return true;
	
	// links unten
	zaehler = 1;
	x = (short)(spalte-1);
	y = feld[spalte][0];
	while ((x>=0) && (y>=1) && (zaehler<4) && (feld[x][y]==spieler)) {
	    zaehler++;
	    x--;
	    y--;
	}
	if (zaehler==4) return true;
	
	// rechts oben
	x = (short)(spalte+1);
	y = (short)(feld[spalte][0]+2);
	while ((x<breite) && (y<=hoehe) && (zaehler<4) && (feld[x][y]==spieler)){
	    zaehler++;
	    x++;
	    y++;
	}
	if (zaehler==4) return true;
	
	// links oben
	zaehler = 1;
	x = (short)(spalte-1);
	y = (short)(feld[spalte][0]+2);
	while ((x>=0) && (y<=hoehe) && (zaehler<4) && (feld[x][y]==spieler)) {
	    zaehler++;
	    x--;
	    y++;
	}
	if (zaehler==4) return true;
	
	// rechts unten
	x = (short)(spalte+1);
	y = (short)(feld[spalte][0]);
	while ((x<breite) && (y>=1) && (zaehler<4) && (feld[x][y]==spieler)) {
	    zaehler++;
	    x++;
	    y--;
	}
	if (zaehler==4) return true;
	
	// unten
	zaehler = 1;
	y = feld[spalte][0];
	while ((y>=1) && (zaehler<4) && (feld[spalte][y]==spieler)) {
	    zaehler++;
	    y--;
	}
	if (zaehler==4) return true;

	return false;
    }
  
  
    
    // Gibt aus, wieviele unguenstige Zuege dem Gegner zur Wahl
    // stehen, nach denen man sicher gewinnt.
    // <spalte> darf nicht im naechsten Schritt gewinnen
    // <spalte> muss einen Gegnerschritt lang sicher sein
  
    private static short spaltenBewertung(short spalte, short spieler, 
					  short schritteNachGegnerZug, 
					  short gegnerintelligenz) {
    
      spalte--; // Anpassung, da 0-basiertes Spielfeld
      short gegner = (short)(spieler %2 +1);
      
      //if (feld[spalte][0]==hoehe) return -1;
      
      //if (spalteGewinnt((short)(spalte+1),spieler)) return 0;
      
      if (schritteNachGegnerZug<=gegnerintelligenz) return 0;
      
      feld[spalte][0]++;
      feld[spalte][feld[spalte][0]]=spieler;
      
      /*
	for (short i=1; i<=breite; i++) 
	if (spalteGewinnt(i,gegner)) {
	feld[spalte][feld[spalte][0]]=0;
	feld[spalte][0]--;
	return false;
	}
      */
            
      short anzahlZuege = 0;
      
      for (short i=0; i<breite; i++){
	
	if ((feld[i][0]<hoehe) && (sichererZug((short)(i+1),
					      gegner,gegnerintelligenz))){
	  
	  feld[i][0]++;
	  feld[i][feld[i][0]]=gegner;
	  
	  short j=0;
	  for (j=1; ((j<=breite) && 
		     (!sichererGewinnZug(j,spieler,schritteNachGegnerZug))); 
	       j++);
	  
	  feld[i][feld[i][0]]=0;
	  feld[i][0]--;
	  
	  if (j<=breite) anzahlZuege++; //Gewinnzug gefunden	     		
	}
	
      }

      feld[spalte][feld[spalte][0]]=0;
      feld[spalte][0]--;
      return anzahlZuege;
	
    }



    private static boolean sichererGewinnZug(short spalte, short spieler, 
					     short schritte) {
	
	if (berechnungsStop) return false;

	spalte--; // Anpassung, da 0-basiertes Spielfeld
	short gegner = (short)(spieler %2 +1);
	
	if (feld[spalte][0]==hoehe) return false;
	
	if (spalteGewinnt((short)(spalte+1),spieler)) return true;

	if (schritte==0) return false;

	feld[spalte][0]++;
	feld[spalte][feld[spalte][0]]=spieler;
	
	for (short i=1; i<=breite; i++) 
	    if (spalteGewinnt(i,gegner)) {
		feld[spalte][feld[spalte][0]]=0;
		feld[spalte][0]--;
		return false;
	    }

	int summe = feld[0][0];
	for (int k=1; k<breite; summe += feld[k++][0]);
	if (summe==breite*hoehe) {
	    feld[spalte][feld[spalte][0]]=0;
	    feld[spalte][0]--;
	    return false;
	}

	for (short i=0; i<breite; i++){

	    if (feld[i][0]<hoehe) {

		feld[i][0]++;
		feld[i][feld[i][0]]=gegner;

		short j=0;
		for (j=1; (j<=breite) && 
			 (!sichererGewinnZug(j,spieler,(short)(schritte-1))); 
		     j++);

		feld[i][feld[i][0]]=0;
		feld[i][0]--;

		if (j==breite+1) { //Kein Gewinnzug gefunden (evtl. alle voll)
		    feld[spalte][feld[spalte][0]]=0;
		    feld[spalte][0]--;
		    return false;
		}
	     		
	    }
	  
	}
	
	feld[spalte][feld[spalte][0]]=0;
	feld[spalte][0]--;
	return true;

    }



    private static boolean sichererZug(short spalte, short spieler, 
				       short schritte) {

	if (berechnungsStop) return false;

	spalte--; // Anpassung, da 0-basiertes Spielfeld
	short gegner = (short)(spieler %2 +1);
	

	if (feld[spalte][0]==hoehe) return false;
	
	if (spalteGewinnt((short)(spalte+1),spieler)) return true;


	feld[spalte][0]++;
	feld[spalte][feld[spalte][0]]=spieler;
	
	for (short i=1; i<=breite; i++) 
	    if (spalteGewinnt(i,gegner)) {
		feld[spalte][feld[spalte][0]]=0;
		feld[spalte][0]--;
		return false;
	    }

	if (schritte==0) {
	    feld[spalte][feld[spalte][0]]=0;
	    feld[spalte][0]--;
	    return true;
	}

	for (short i=0; i<breite; i++){

	    if (feld[i][0]<hoehe) {

		feld[i][0]++;
		feld[i][feld[i][0]]=gegner;

		short j=0;
		for (j=1; (j<=breite) && 
			 (!sichererZug(j,spieler,(short)(schritte-1))); j++);

		feld[i][feld[i][0]]=0;
		feld[i][0]--;

		if (j==breite+1) { //Kein sicherer Zug gefunden (alle voll?)
		    int summe = feld[0][0];
		    for (int k=1; k<breite; summe += feld[k++][0]);
		    feld[spalte][feld[spalte][0]]=0;
		    feld[spalte][0]--;
		    if (summe==breite*hoehe-2) return true;
		    return false;
		}
		
	    }
	  
	}
	
	feld[spalte][feld[spalte][0]]=0;
	feld[spalte][0]--;
	return true;

    }


/**
 * Liefert den momentan besten Zug f&uuml;r den &uuml;bergebenen Spieler 
 * zur&uuml;ck.
 * @param spieler Nummer des Spielers.
 * @param feld Das aktuelle Spielfeld.
 * @return Spaltennummer in [1..Spielfeldbreite] 
 */
    public short besterZug(short spieler,short[][] feld) 
    {
	class TimerThread extends Thread {
	    private long maxMillis = 0;
	    private boolean timerBeenden=false;
	    public void setzeDauer(long maxMillis)
	    {
		this.maxMillis=maxMillis;
	    }
	    public void setzeTimerBeenden() {
		timerBeenden=true;
	    }
	    public void run() {
		try {
		    long startzeit = System.currentTimeMillis();
		    long verbrauchteZeit=0;
		    while ((verbrauchteZeit <= maxMillis) 
			   && (!(timerBeenden))){ 
			// wacht manchmal zu frueh auf!
			Thread.sleep(maxMillis-verbrauchteZeit);
			verbrauchteZeit=System.currentTimeMillis()-startzeit;
		    }
		    if (!(timerBeenden)) {
			berechnungsStop = true;
			System.out.print(" Timeout");
		    }
		} catch (InterruptedException e) {}
	    }
	}

	this.feld=feld;
	
	TimerThread timer = null;	
	short mitte = (short)(breite / 2 + breite % 2);
	short spalte;
	
	short maxZuege = feld[0][0];
	for (int i=1; i<breite; maxZuege+=feld[i++][0]);
	maxZuege = (short)((breite*hoehe-maxZuege)/2);
	
	spalte = mitte;
	System.out.println("\nPruefe auf eigenen Gewinn im naechsten Zug:");
	for (short i=0; i<breite; i++){
	    spalte = (short)(spalte + ((i % 2 == 0)? -i : i));
	    System.out.print(" "+spalte);
	    if (spalteGewinnt(spalte,spieler)) {
		System.out.print("+");
		return spalte;
	    }
	}
	
	
	spalte = mitte;
	System.out.println("\nPruefe auf Gewinn des Gegners im naechsten Zug:");
	for (short i=0; i<breite; i++){
	    spalte = (short)(spalte + ((i % 2 == 0)? -i : i));
	    System.out.print(" "+spalte);
	    if (spalteGewinnt(spalte,(short)(spieler%2+1))) {
		System.out.print("+");
		return spalte;
	    }
	}
	
	
	berechnungsStop = false;
	timer = new TimerThread();
	timer.setzeDauer(MAXZEIT);
	timer.start();
	Thread.currentThread().yield();
	for (short j=1; (!(berechnungsStop)) && (j<maxZuege); j++) {
	    spalte = mitte;
	    System.out.println("\nPruefe auf eigenen Gewinn in "+j+" Zuegen:");
	    for (short i=0; i<breite; i++){
		spalte = (short)(spalte + ((i % 2 == 0)? -i : i));
		System.out.print(" "+spalte);
		if (sichererGewinnZug(spalte,spieler,j)) {
		    System.out.print("+");
		    if (!(berechnungsStop)) {
			timer.setzeTimerBeenden();
			System.out.print(" Fertig");
		    }
		    return spalte;
		}
	    }
	}
	if (!(berechnungsStop)) {
	    timer.setzeTimerBeenden();
	    System.out.print(" Fertig");
	}
	
	short[] sicherheitsArray = new short[breite];
	for (int i=0; i<breite; i++) sicherheitsArray[i]=-1;
	short besteAnzahlSchritte = -1;
	short letzteAnzahlSchritte = -1;
	
	berechnungsStop = false;
	timer = new TimerThread();
	timer.setzeDauer(MAXZEIT);
	timer.start();
	Thread.currentThread().yield();
	for (short j=0; (!(berechnungsStop)) && 
		 (besteAnzahlSchritte==(short)(j-1)) && (j<maxZuege); j++) {
	    System.out.println("\nPruefe auf Nichtverlieren in "+j+" Zuegen:");
	    spalte = mitte;
	    letzteAnzahlSchritte=j;
	    for (short i=0; i<breite; i++){
		spalte = (short)(spalte + ((i % 2 == 0)? -i : i));
		System.out.print(" "+spalte);
		if (sicherheitsArray[spalte-1]==(short)(j-1)) { 
		    //deshalb sicherheitsArray mit -1 initialisiert
		    if (sichererZug(spalte,spieler,j)) {
			System.out.print("+");
			sicherheitsArray[spalte-1]=j;
			besteAnzahlSchritte=j;
		    }
		}
	    }
	}
	if (!(berechnungsStop)) {
	    timer.setzeTimerBeenden();
	    System.out.print(" Fertig");
	}


	timer = new TimerThread();
	if (besteAnzahlSchritte>-1) { //wenn mind. ein sicherer Zug gefunden
	    boolean besteAnzahlGesehen = false;
	    spalte=(breite %2 == 0) ? breite : (short)1;
	    for (int i=breite-1; i>=0; i--) { // Array vor-auswerten
		if (sicherheitsArray[spalte-1]==besteAnzahlSchritte) {
		    sicherheitsArray[spalte-1]=SICHERHEITSBONUS;
		    besteAnzahlGesehen = true;
		}
		else {
		    if ((sicherheitsArray[spalte-1]==besteAnzahlSchritte-1)
			&& (besteAnzahlSchritte==letzteAnzahlSchritte)
			&& (sicherheitsArray[spalte-1]>=MINDESTSICHERHEIT) 
			&& (!(besteAnzahlGesehen)))
			sicherheitsArray[spalte-1] = 0; 
		    else sicherheitsArray[spalte-1]=-1;
		}
		spalte = (short)(spalte - ((i % 2 == 0)? -i : i));
	    }
	    

	    short[] bewertungsArray = new short[breite];
	    for (int i=0; i<breite; i++) bewertungsArray[i]=-1;

	    berechnungsStop = false;
	    timer.setzeDauer(MAXZEIT/3);
	    timer.start(); // wurde oben instantiiert
	    Thread.currentThread().yield();
	    for (short j=0; (!(berechnungsStop)) && (j<maxZuege); j++) {
		spalte = mitte;
		System.out.println("\nPruefe sichere Zuege auf moeglichst viele Fehlerchancen des Gegners ("+j+"):");

		for (int i=0; i<breite; i++) {
		    spalte = (short)(spalte + ((i % 2 == 0)? -i : i));
		    System.out.print(" "+spalte);
		    
		    if (sicherheitsArray[spalte-1]>-1) { // bei sicheren Zuegen
			short temp = 
			  spaltenBewertung(spalte,spieler,j,GEGNERVORAUSSCHAU);
			if (!(berechnungsStop)) 
			    bewertungsArray[spalte-1]=temp;
			System.out.print("("+bewertungsArray[spalte-1]+")");
		    }
		}
	    }
	    if (!(berechnungsStop)) {
		timer.setzeTimerBeenden();
		System.out.print(" Fertig");
	    }
	        
	    spalte = mitte;
	    System.out.println("\nEndgueltige Bewertung:");
	    short besteSpalte=0;
	    double besteBewertung=0;
	    for (int i=0; i<breite; i++) { //endgueltige Bewertung;
		spalte = (short)(spalte + ((i % 2 == 0)? -i : i));
		if (sicherheitsArray[spalte-1]>-1){
		    double aktuelleBewertung 
			= (double)sicherheitsArray[spalte-1]/(double)2 
			+ (double)bewertungsArray[spalte-1];
		    if (aktuelleBewertung>besteBewertung) {
			besteSpalte=spalte;
			besteBewertung=aktuelleBewertung;
		    }
		    System.out.print(" "+spalte+"("+aktuelleBewertung+")");
		}
	    }
	    return besteSpalte;
	}


	spalte = mitte;
	System.out.println("\nPruefe auf Zugmoeglichkeit:");
	for (short i=0; i<breite; i++){
	    spalte = (short)(spalte + ((i % 2 == 0)? -i : i));
	    System.out.print(" "+spalte);
	    if (feld[spalte-1][0]<hoehe) {
		System.out.print("+");
		return spalte;
	    }
	}

	return (short)-1; //Kommt nicht vor?!
    }

/**
 * Setzt die Bedenkzeit fr die besterZug-Methode.
 * @param maxZeitMillis Bedenkzeit in ms. Die tats&auml;chliche 
 * Berechnungszeit betr&auml;gt 7/3 mal diesen Wert.
 */
    public void spielstaerke(int maxZeitMillis) {
	if (maxZeitMillis>0) MAXZEIT=maxZeitMillis;
    }
}
