//Author:      (c) 2000, Elias Volanakis

import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.net.*;
import java.util.*;
import java.io.*;
import HttpMessage;

public class mmApplet extends Applet implements ActionListener
{
    // Applet<->Servlet communikation
    // BITTE SERVLET_LOC ANPASSEN !!!!
    private static final String SERVLET_LOC = "/servlet/aufgaben.user_id.mmServlet";
    private URL url;
    private HttpMessage msg;
    Properties props;
    
    // GUI
    private TextField codeTextField;
    private List codeList;
    private Label statusLabel;
    private Button sendButton, resetButton;
    private Panel buttonPanel, southPanel, inputPanel;

    public void init() {
	// Erzeugt die Benutzeroberflche 
	buttonPanel = new Panel(new GridLayout(1,2,5,5));
	sendButton = new Button("Senden");
	sendButton.setEnabled(false);
	resetButton = new Button("NEUSTART");
	buttonPanel.add(sendButton);
	buttonPanel.add(resetButton);
	
	inputPanel = new Panel(new BorderLayout());
	codeTextField = new TextField(5);
	inputPanel.add("West",new Label(" Code = "));
	inputPanel.add("Center",codeTextField);
	
	southPanel = new Panel(new GridLayout(3,1,5,5));
	statusLabel = new Label("");
	southPanel.add(statusLabel);
	southPanel.add(inputPanel);
	southPanel.add(buttonPanel);

	codeList = new List(10);

	sendButton.addActionListener(this);
	resetButton.addActionListener(this);
	
	setLayout(new BorderLayout());
	add("North",new Label(" Ausprobierte Codes"));
	add("Center",codeList);
	add("South",southPanel);

	// Initialisiere Variablen
	try {
	    // Erzeuge URL mit der Adresse an der das Servlet zu finden ist.
	    url = new URL(getCodeBase(), SERVLET_LOC);
	}
	catch (MalformedURLException e) {
	    e.printStackTrace();
	    System.err.println("Sollte nicht passieren !! Check SERVLET_LOC !");
	}
	// Erzeuge HttpMessage Objekt mit der Url
	msg = new HttpMessage(url); 
	// Erzeuge neues Properties Objekt (Zweck: Kann Werte Paare enthalten)
	props = new Properties();  
    }

    // Event handling
    public void actionPerformed(ActionEvent e) {
	// resetButton: Neuen Code erzeugen lassen (vom Servlet)
	if (e.getSource() == resetButton) {
	    if (createCode()) {
		// GUI Auframen
		codeTextField.setText("");
		codeList.removeAll();
		sendButton.setEnabled(true);
		statusLabel.setText(" Versuchen Sie den Code zu finden...");
		
	    }
	    else
		statusLabel.setText(" Fehler bei der Kommunikation mit Servlet.");
	}
	// sendButton: Sende Code zur bearbeitung an Servlet
	else if (e.getSource() == sendButton) {
	    String aCode = (codeTextField.getText()).trim();
	    if (!validateCode(aCode)) // Kein Muell ??
		return;
	    
	    sendCode(aCode);
	}
    }
    
    
    // Plausibilittscheck fr code
    private boolean validateCode(String aCode) {
	if (aCode.length() != 5) {
	    statusLabel.setText("Der Code mu FNF Zahlen enthalten !");
	    return false;
	}
	try { // Nur Zahlen enthalten ?
	    int tmp = new Integer(aCode).intValue();
	}
	catch (NumberFormatException e) {
	    statusLabel.setText("Der Code mu fnf ZAHLEN enthalten !");
	    return false;
	}
	
	return true;
    }
    
    // Ruft das Servlet auf und bermittelt den Parameter: action=code
    private boolean createCode() { 
	try {
	    // Property-Liste lschen
	    props.clear();
	    // Parameter hinzufgen (Name, Wert)
	    props.put("action", "code");
	    // Ans Servlet schicken.
	    msg.sendGetMessage(props);
	    
	    return true; 
	}
	catch (Exception e) {
	    e.printStackTrace();
	    return false;
	}
    }
    
    // Schickt einen Code zur Bearbeitung an das Servlet. Erhlt das
    // Ergebniss zurck und zeigt es an. Wenn gewonnen wird Nachricht ausgegeben.
    private boolean sendCode(String aCode)  { 
	try {
	    // Property-Liste lschen
	    props.clear();
	    // Parameter hinzufgen
	    props.put("action", "validate");
	    // Code hinzufgen
	    props.put("code",aCode);
	   
	    // Jetzt brauchen wir das InputStream um die Antwort des Servlets
	    // zu bearbeiten
	    InputStream in = msg.sendGetMessage(props);
	    // Komfortabler...
            BufferedReader result = new BufferedReader(new InputStreamReader(in));

	    // Hier ist die erste (und einzige, weil so programmiert) Zeile
	    // der Antwort (vom Servlet).
            String resp = result.readLine();
	    // InputStream wird jetzt nicht mehr gebraucht...
	    in.close();

	    // Antwort bearbeiten. Format ist: 
	    // <VersuchsNr.>,<Zahlen an richtiger Position>,<Zahl. enthalten, an anderer Stelle>
	    StringTokenizer st = new StringTokenizer(resp,",");
	    int i = 0, tryNum=0, kp=0, np=0;
	    while (st.hasMoreTokens()) {
		switch(i) {
		case 0:
		    tryNum = new Integer(st.nextToken()).intValue(); break;
		case 1:
		    kp = new Integer(st.nextToken()).intValue(); break;
		case 2:
		    np = new Integer(st.nextToken()).intValue(); break;
		}
		i++;
	    }

	    // Ergebniss der Liste hinzufgen
	    codeList.add(tryNum+":   "+aCode+"   KP: "+kp+" NP: "+np);

	    // Gewonnen ??
	    if ((kp==5) && (np==0)) {
		sendButton.setEnabled(false);
		statusLabel.setText("GRATULIERE! Sie haben den Code geknackt !");
	    } 
	    return true;
	}
	catch (Exception e) {
	    e.printStackTrace();
	    return false;
	}
    }

}
