// package com.oreilly.servlet;
// Aus dem O'Reily Buch, Java Servlet Programming

import java.io.*;
import java.net.*;
import java.util.*;

/** Sendet Http GET und POST requests an die im Konstruktor angegebene Adresse,
    mit/ohne Parameter. Dazu wird das URLConnection Objekt benutzt.
*/
public class HttpMessage {
    URL servlet = null;
    String args = null;

    public HttpMessage(URL servlet) { this.servlet = servlet; }

    // Performs a GET request to the previously given servlet
    // with no query string.
    public InputStream sendGetMessage() 
    throws IOException {
	return sendGetMessage(null);
    }

    // Performs a GET request to the previously given servlet.
    // Builds a query string from the supplied Properties list.
    public InputStream sendGetMessage(Properties args) 
    throws IOException {
	String argString = "";  // default

	if (args != null) {
	    argString = "?" + toEncodedString(args);
	}
	URL url = new URL(servlet.toExternalForm() + argString);

	// Turn off caching
	URLConnection con = url.openConnection();
	con.setUseCaches(false);

	return con.getInputStream();
    }

    // Performs a POST request to the previously given servlet
    // with no query String.
    public InputStream sendPostMessage()
    throws IOException {
	return sendPostMessage(null);
    }

    // Performs a POST request to the previously given servlet.
    // Build post date from the supplied Properties list.
    public InputStream sendPostMessage(Properties args)
    throws IOException {
	String argString = "";  // default

	if (args != null) {
	    argString = toEncodedString(args);  // notice no "?"
	}

	URLConnection con = servlet.openConnection();

	// Prepare for both input and output
	con.setDoInput(true);
	con.setDoOutput(true);
	// Turn off caching
	con.setUseCaches(false);

	// Work around a Netscape bug
	con.setRequestProperty("Content-Type","application/x-www-form-urlencoded");

	// Write arguments as post data
	DataOutputStream out = new DataOutputStream(con.getOutputStream());
	out.writeBytes(argString);
	out.flush();
	out.close();

	return con.getInputStream();
    }

    // Uploads a serialized object with a POST request.
    // Sets the content type to java-internal/classname.
    public InputStream sendPostMessage(Serializable obj)
    throws IOException
    {
	URLConnection con = servlet.openConnection();
	con.setDoInput(true);
	con.setDoOutput(true);
	con.setUseCaches(false);
	
	// Set content type to be java-internal/classname
	con.setRequestProperty("Content-Type","java-internal/"+obj.getClass().getName());

	// Write the serialized object as post data
	ObjectOutputStream out = new ObjectOutputStream(con.getOutputStream());
	out.writeObject(obj);
	out.flush();
	out.close();

	return con.getInputStream();
    }

    // Converts a Properties list to a URL-encoded query string
    private String toEncodedString(Properties args) {
	StringBuffer buf = new StringBuffer();
	Enumeration names = args.propertyNames();
	while (names.hasMoreElements()) {
	    String name = (String)names.nextElement();
	    String value = args.getProperty(name);
	    buf.append(URLEncoder.encode(name) + "=" + URLEncoder.encode(value));
	    if (names.hasMoreElements()) buf.append("&");
	}
	return buf.toString();
    }    
}
